-----------------------------------------------------------------------
--  util-log-loggers-traceback-gnat -- GNAT symbolic traceback
--  Copyright (C) 2012 Stephane Carrez
--  Written by Stephane Carrez (Stephane.Carrez@gmail.com)
--
--  Licensed under the Apache License, Version 2.0 (the "License");
--  you may not use this file except in compliance with the License.
--  You may obtain a copy of the License at
--
--      http://www.apache.org/licenses/LICENSE-2.0
--
--  Unless required by applicable law or agreed to in writing, software
--  distributed under the License is distributed on an "AS IS" BASIS,
--  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
--  See the License for the specific language governing permissions and
--  limitations under the License.
-----------------------------------------------------------------------
with GNAT.Traceback.Symbolic;

separate (Util.Log.Loggers)

--  ------------------------------
--  Return a printable traceback that correspond to the exception.
--  ------------------------------
function Traceback (E : in Exception_Occurrence) return String is
begin
   return GNAT.Traceback.Symbolic.Symbolic_Traceback (E);
end Traceback;
