-----------------------------------------------------------------------
--  Util.Beans.Objects.To_Access -- Conversion utility
--  Copyright (C) 2011 Stephane Carrez
--  Written by Stephane Carrez (Stephane.Carrez@gmail.com)
--
--  Licensed under the Apache License, Version 2.0 (the "License");
--  you may not use this file except in compliance with the License.
--  You may obtain a copy of the License at
--
--      http://www.apache.org/licenses/LICENSE-2.0
--
--  Unless required by applicable law or agreed to in writing, software
--  distributed under the License is distributed on an "AS IS" BASIS,
--  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
--  See the License for the specific language governing permissions and
--  limitations under the License.
-----------------------------------------------------------------------

--  Convert the object to the corresponding access type.
--  Returns null if the object is not a <b>TYPE_BEAN</b> or not of the given bean type.
with Util.Beans.Basic;
generic
   type T is limited new Util.Beans.Basic.Readonly_Bean with private;
   type T_Access is access all T'Class;
function Util.Beans.Objects.To_Access (Value : in Object) return T_Access;
